/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.ui.preferences;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.asnlab.asndt.core.AsnConventions;
import org.asnlab.asndt.core.AsnCore;
import org.asnlab.asndt.core.IAsnProject;
import org.asnlab.asndt.core.IBuildPathEntry;
import org.asnlab.asndt.internal.corext.util.Messages;
import org.asnlab.asndt.internal.ui.AsnPlugin;
import org.asnlab.asndt.internal.ui.dialogs.StatusInfo;
import org.asnlab.asndt.internal.ui.dialogs.StatusUtil;
import org.asnlab.asndt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class NewAsnProjectPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "org.asnlab.asndt.ui.preferences.CompliancePreferencePage";
    private static final String SRCBIN_SRCNAME = "org.asnlab.asndt.ui.wizards.srcName";
    private static final String SRCBIN_BINNAME = "org.asnlab.asndt.ui.wizards.binName";
    private static final String STANDARD_LIB_INDEX = "org.asnlab.asndt.ui.wizards.jre.index";
    private static final String STANDARD_LIB_LIST = "org.asnlab.asndt.ui.wizards.jre.list";
    private ArrayList fCheckBoxes;
    private ArrayList fRadioButtons;
    private ArrayList fTextControls;
    private ModifyListener fModifyListener;
    private Text fSrcFolderNameText;
    private Text fBinFolderNameText;
    private Combo fSystemLibCombo;
    private Label fSrcFolderNameLabel;
    private Label fBinFolderNameLabel;

    public NewAsnProjectPreferencePage() {
        this.setPreferenceStore(AsnPlugin.getDefault().getPreferenceStore());
        this.setDescription(PreferencesMessages.NewAsnProjectPreferencePage_description);
        this.setTitle(PreferencesMessages.NewAsnProjectPreferencePage_title);
        this.fRadioButtons = new ArrayList();
        this.fCheckBoxes = new ArrayList();
        this.fTextControls = new ArrayList();
        this.fModifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewAsnProjectPreferencePage.this.controlModified(e.widget);
            }
        };
    }

    public static void initDefaults(IPreferenceStore store) {
        store.setDefault(SRCBIN_SRCNAME, "source");
        store.setDefault(SRCBIN_BINNAME, "output");
        store.setDefault(STANDARD_LIB_LIST, NewAsnProjectPreferencePage.getDefaultStandardLibs());
        store.setDefault(STANDARD_LIB_INDEX, 0);
    }

    private static String getDefaultStandardLibs() {
        return "ASN.1:1997";
    }

    public void init(IWorkbench workbench) {
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.asnlab.asndt.ui.new_asn_project_preference_page_context");
    }

    private Text addTextControl(Composite parent, Label labelControl, String key, int indent) {
        GridData gd = new GridData();
        gd.horizontalIndent = indent;
        labelControl.setLayoutData((Object)gd);
        gd = new GridData(768);
        gd.widthHint = this.convertWidthInCharsToPixels(30);
        Text text = new Text(parent, 2052);
        text.setText(this.getPreferenceStore().getString(key));
        text.setData((Object)key);
        text.setLayoutData((Object)gd);
        this.fTextControls.add(text);
        return text;
    }

    protected Control createContents(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = 0;
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(10);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.numColumns = 2;
        result.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        Group sourceFolderGroup = new Group(result, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        sourceFolderGroup.setLayout((Layout)layout);
        sourceFolderGroup.setLayoutData((Object)gd);
        sourceFolderGroup.setText(PreferencesMessages.NewAsnProjectPreferencePage_sourcefolder_label);
        int indent = 0;
        this.fSrcFolderNameLabel = new Label((Composite)sourceFolderGroup, 0);
        this.fSrcFolderNameLabel.setText(PreferencesMessages.NewAsnProjectPreferencePage_folders_src);
        this.fSrcFolderNameText = this.addTextControl((Composite)sourceFolderGroup, this.fSrcFolderNameLabel, SRCBIN_SRCNAME, indent);
        this.fSrcFolderNameText.addModifyListener(this.fModifyListener);
        this.fBinFolderNameLabel = new Label((Composite)sourceFolderGroup, 0);
        this.fBinFolderNameLabel.setText(PreferencesMessages.NewAsnProjectPreferencePage_folders_bin);
        this.fBinFolderNameText = this.addTextControl((Composite)sourceFolderGroup, this.fBinFolderNameLabel, SRCBIN_BINNAME, indent);
        this.fBinFolderNameText.addModifyListener(this.fModifyListener);
        String[] standardNames = this.getStandardLibNames();
        if (standardNames.length > 0) {
            Label standardSelectionLabel = new Label(result, 0);
            standardSelectionLabel.setText(PreferencesMessages.NewAsnProjectPreferencePage_standard_library_label);
            standardSelectionLabel.setLayoutData((Object)new GridData());
            int index = this.getPreferenceStore().getInt(STANDARD_LIB_INDEX);
            this.fSystemLibCombo = new Combo(result, 8);
            this.fSystemLibCombo.setItems(standardNames);
            this.fSystemLibCombo.select(index);
            this.fSystemLibCombo.setLayoutData((Object)new GridData(256));
        }
        this.validateFolders();
        Dialog.applyDialogFont((Control)result);
        return result;
    }

    private void validateFolders() {
        IStatus status;
        String srcName = this.fSrcFolderNameText.getText();
        String binName = this.fBinFolderNameText.getText();
        if (srcName.length() == 0 || binName.length() == 0) {
            this.updateStatus(new StatusInfo(4, PreferencesMessages.NewAsnProjectPreferencePage_folders_error_namesempty));
            return;
        }
        IWorkspace workspace = AsnPlugin.getWorkspace();
        IProject dmy = workspace.getRoot().getProject("project");
        IPath srcPath = dmy.getFullPath().append(srcName);
        if (srcName.length() != 0 && !(status = workspace.validatePath(srcPath.toString(), 2)).isOK()) {
            String message = Messages.format(PreferencesMessages.NewAsnProjectPreferencePage_folders_error_invalidsrcname, status.getMessage());
            this.updateStatus(new StatusInfo(4, message));
            return;
        }
        IPath binPath = dmy.getFullPath().append(binName);
        if (binName.length() != 0 && !(status = workspace.validatePath(binPath.toString(), 2)).isOK()) {
            String message = Messages.format(PreferencesMessages.NewAsnProjectPreferencePage_folders_error_invalidbinname, status.getMessage());
            this.updateStatus(new StatusInfo(4, message));
            return;
        }
        IBuildPathEntry srcEntry = AsnCore.newSourceEntry((IPath)srcPath);
        IBuildPathEntry binEntry = AsnCore.newOutputEntry((IPath)binPath);
        status = AsnConventions.validateBuildPath((IAsnProject)AsnCore.create((IProject)dmy), (IBuildPathEntry[])new IBuildPathEntry[]{srcEntry, binEntry});
        if (!status.isOK()) {
            String message = PreferencesMessages.NewAsnProjectPreferencePage_folders_error_invalidcp;
            this.updateStatus(new StatusInfo(4, message));
            return;
        }
        this.updateStatus(new StatusInfo());
    }

    private void updateStatus(IStatus status) {
        this.setValid(!status.matches(4));
        StatusUtil.applyToStatusLine((DialogPage)this, status);
    }

    private void controlModified(Widget widget) {
        if (widget == this.fSrcFolderNameText || widget == this.fBinFolderNameText) {
            this.validateFolders();
        }
    }

    protected void performDefaults() {
        String key;
        Button button;
        IPreferenceStore store = this.getPreferenceStore();
        int i = 0;
        while (i < this.fCheckBoxes.size()) {
            button = (Button)this.fCheckBoxes.get(i);
            key = (String)button.getData();
            button.setSelection(store.getDefaultBoolean(key));
            ++i;
        }
        i = 0;
        while (i < this.fRadioButtons.size()) {
            button = (Button)this.fRadioButtons.get(i);
            String[] info = (String[])button.getData();
            button.setSelection(info[1].equals(store.getDefaultString(info[0])));
            ++i;
        }
        i = 0;
        while (i < this.fTextControls.size()) {
            Text text = (Text)this.fTextControls.get(i);
            key = (String)text.getData();
            text.setText(store.getDefaultString(key));
            ++i;
        }
        if (this.fSystemLibCombo != null) {
            this.fSystemLibCombo.select(store.getDefaultInt(STANDARD_LIB_INDEX));
        }
        this.validateFolders();
        super.performDefaults();
    }

    public boolean performOk() {
        String key;
        Button button;
        IPreferenceStore store = this.getPreferenceStore();
        int i = 0;
        while (i < this.fCheckBoxes.size()) {
            button = (Button)this.fCheckBoxes.get(i);
            key = (String)button.getData();
            store.setValue(key, button.getSelection());
            ++i;
        }
        i = 0;
        while (i < this.fRadioButtons.size()) {
            button = (Button)this.fRadioButtons.get(i);
            if (button.getSelection()) {
                String[] info = (String[])button.getData();
                store.setValue(info[0], info[1]);
            }
            ++i;
        }
        i = 0;
        while (i < this.fTextControls.size()) {
            Text text = (Text)this.fTextControls.get(i);
            key = (String)text.getData();
            store.setValue(key, text.getText());
            ++i;
        }
        if (this.fSystemLibCombo != null) {
            store.setValue(STANDARD_LIB_INDEX, this.fSystemLibCombo.getSelectionIndex());
        }
        AsnPlugin.getDefault().savePluginPreferences();
        return super.performOk();
    }

    private String[] getStandardLibNames() {
        String prefString = this.getPreferenceStore().getString(STANDARD_LIB_LIST);
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer tok = new StringTokenizer(prefString, ";");
        while (tok.hasMoreTokens()) {
            list.add(tok.nextToken());
        }
        return list.toArray(new String[list.size()]);
    }
}

