/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.ui.util;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.swt.custom.BusyIndicator;

public class BusyIndicatorRunnableContext
implements IRunnableContext {
    public void run(boolean fork, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        BusyRunnable busyRunnable = new BusyRunnable(fork, runnable);
        BusyIndicator.showWhile(null, (Runnable)busyRunnable);
        Throwable throwable = busyRunnable.fThrowable;
        if (throwable instanceof InvocationTargetException) {
            throw (InvocationTargetException)throwable;
        }
        if (throwable instanceof InterruptedException) {
            throw (InterruptedException)throwable;
        }
    }

    private static class BusyRunnable
    implements Runnable {
        public Throwable fThrowable;
        private boolean fFork;
        private IRunnableWithProgress fRunnable;

        public BusyRunnable(boolean fork, IRunnableWithProgress runnable) {
            this.fFork = fork;
            this.fRunnable = runnable;
        }

        public void run() {
            try {
                this.internalRun(this.fFork, this.fRunnable);
            }
            catch (InvocationTargetException e) {
                this.fThrowable = e;
            }
            catch (InterruptedException e) {
                this.fThrowable = e;
            }
        }

        private void internalRun(boolean fork, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
            Thread thread = Thread.currentThread();
            if (thread instanceof ThreadContext || ModalContext.isModalContextThread((Thread)thread)) {
                fork = false;
            }
            if (fork) {
                ThreadContext t = new ThreadContext(runnable);
                t.start();
                t.sync();
                Throwable throwable = t.fThrowable;
                if (throwable != null) {
                    if (throwable instanceof InvocationTargetException) {
                        throw (InvocationTargetException)throwable;
                    }
                    if (throwable instanceof InterruptedException) {
                        throw (InterruptedException)throwable;
                    }
                    if (throwable instanceof OperationCanceledException) {
                        throw new InterruptedException();
                    }
                    throw new InvocationTargetException(throwable);
                }
            } else {
                try {
                    runnable.run((IProgressMonitor)new NullProgressMonitor());
                }
                catch (OperationCanceledException operationCanceledException) {
                    throw new InterruptedException();
                }
            }
        }

        private static class ThreadContext
        extends Thread {
            IRunnableWithProgress fRunnable;
            Throwable fThrowable;

            public ThreadContext(IRunnableWithProgress runnable) {
                this(runnable, "BusyCursorRunnableContext-Thread");
            }

            protected ThreadContext(IRunnableWithProgress runnable, String name) {
                super(name);
                this.fRunnable = runnable;
            }

            public void run() {
                try {
                    this.fRunnable.run((IProgressMonitor)new NullProgressMonitor());
                }
                catch (InvocationTargetException e) {
                    this.fThrowable = e;
                }
                catch (InterruptedException e) {
                    this.fThrowable = e;
                }
                catch (ThreadDeath e) {
                    this.fThrowable = e;
                    throw e;
                }
                catch (RuntimeException e) {
                    this.fThrowable = e;
                }
                catch (Error e) {
                    this.fThrowable = e;
                }
            }

            void sync() {
                try {
                    this.join();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

